%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Moving Finite Line Source   (MFLS): Molina et al. 2011                  %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_MFLS(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
Dt = lm/Cm;             % thermal diffusivity [m2/s]

% Temperature change
T = QL*(1/4/pi/lm)*exp(vT*x/2/Dt).*...
(quadgk(@(ze) T_GIGF(x,y,z,ze,Dt,t,vT)/sqrt(pi)./sqrt(x.^2+y.^2+(z-ze).^2),0,H)-...
 quadgk(@(ze) T_GIGF(x,y,z,ze,Dt,t,vT)/sqrt(pi)./sqrt(x.^2+y.^2+(z-ze).^2),-H,0));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Approximation of the Generalized Incomplete Gamma Function              %
% Chaudhry & Zubair 1994                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function fun = T_GIGF(x,y,z,ze,a,t,VT)
u1 = (x.^2+y.^2+(z-ze).^2)/4/a/t;
u2 = VT^2*(x.^2+y.^2+(z-ze).^2)/16/a^2;
fun = 0.5*sqrt(pi)*(exp(-2*sqrt(u2)).*erfc(sqrt(u1)-sqrt(u2./u1))+...
                    exp(+2*sqrt(u2)).*erfc(sqrt(u1)+sqrt(u2./u1)));

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 